import pandas as pd, matplotlib.pyplot as plt
df = pd.read_csv("outputs/flat_rc_summary.csv")
df = df[df["claimable"]==True]
plt.figure()
plt.scatter(df["v_flat_meas_kms"], df["v_flat_AR_kms"], s=16, alpha=0.7)
mx = max(df["v_flat_meas_kms"].max(), df["v_flat_AR_kms"].max())
plt.plot([0,mx],[0,mx])
plt.xlabel("Observed v_flat [km/s]"); plt.ylabel("Predicted v_flat [km/s]")
plt.title("T1: Predicted vs Observed (claimable)")
plt.savefig("figures/pred_vs_obs.png", dpi=160, bbox_inches="tight")
print("Saved figures/pred_vs_obs.png")
